/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.chat.client;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.chat.client.ChatMessage;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.BusTicket;
import de.hardcode.hq.objectbus.BusTicketListener;
import java.util.ArrayList;
import java.util.Iterator;

class ChatReceiver
implements BusTicketListener {
    private final ArrayList mIncomingMessages = new ArrayList();
    private final ChatClient mChat;

    ChatReceiver(ChatClient chat) {
        this.mChat = chat;
    }

    public void arrived(BusLine l, BusTicket t) {
        String sendername = null;
        Identity senderid = null;
        byte sendertype = t.getByte();
        if (sendertype == 1) {
            sendername = t.getString();
        } else if (sendertype == 2) {
            senderid = t.getIdentity();
        }
        String s = t.getString();
        ChatMessage m = new ChatMessage(senderid, sendername, s);
        this.mIncomingMessages.add(m);
        this.mChat.notifyNewMessage(m);
    }

    Iterator getIncoming() {
        return this.mIncomingMessages.iterator();
    }

    void clear() {
        this.mIncomingMessages.clear();
    }

    int getMessageCount() {
        return this.mIncomingMessages.size();
    }

    ChatMessage getMessage(int idx) {
        return (ChatMessage)this.mIncomingMessages.get(idx);
    }
}

