/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.chat.client;

import de.hardcode.hq.chat.client.ChatListener;
import de.hardcode.hq.chat.client.ChatMessage;
import de.hardcode.hq.chat.client.ChatReceiver;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.objectbus.BusTicket;
import java.util.ArrayList;
import java.util.Iterator;

public class ChatClient {
    private final BusStation mStation;
    private final Identity mProtocolID;
    private final ChatReceiver mReceiver = new ChatReceiver(this);
    private final ArrayList mListeners = new ArrayList();
    private final BusTicket mTicket;

    public ChatClient(BusStation station, Identity protocolID) {
        this.mStation = station;
        this.mProtocolID = protocolID;
        this.mTicket = new BusTicket(this.mProtocolID);
        this.mStation.add(this.mProtocolID, this.mReceiver);
    }

    public void close() {
        this.mStation.remove(this.mProtocolID, this.mReceiver);
    }

    public Iterator getIncoming() {
        return this.mReceiver.getIncoming();
    }

    public void clear() {
        this.mReceiver.clear();
    }

    int getMessageCount() {
        return this.mReceiver.getMessageCount();
    }

    ChatMessage getMessage(int idx) {
        return this.mReceiver.getMessage(idx);
    }

    public void send(String text) {
        BusTicket ticket = this.createTicket((byte)0);
        ticket.putString(text);
        this.sendTicket(ticket);
    }

    public void send(String sender, String text) {
        BusTicket ticket = this.createTicket((byte)1);
        ticket.putString(sender);
        ticket.putString(text);
        this.sendTicket(ticket);
    }

    public void send(Identity sender, String text) {
        BusTicket ticket = this.createTicket((byte)2);
        ticket.putID(sender);
        ticket.putString(text);
        this.sendTicket(ticket);
    }

    private final BusTicket createTicket(byte sendertype) {
        this.mTicket.clear();
        this.mTicket.putByte(sendertype);
        return this.mTicket;
    }

    private final void sendTicket(BusTicket ticket) {
        this.mStation.broadcast(ticket, null);
    }

    public void addListener(ChatListener l) {
        this.mListeners.add(l);
    }

    public void removeListener(ChatListener l) {
        this.mListeners.remove(l);
    }

    void notifyNewMessage(ChatMessage msg) {
        int cnt = this.mListeners.size();
        for (int i = cnt - 1; i >= 0; --i) {
            ((ChatListener)this.mListeners.get(i)).newMessage(msg);
        }
    }
}

