/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.app;

import de.hardcode.hq.app.TestIDs;
import de.hardcode.hq.chat.server.ChatServer;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.NamedIdentity;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.location.client.LocationsClient;
import de.hardcode.hq.location.server.LocationsServer;
import de.hardcode.hq.objectbus.NetStation;
import de.hardcode.hq.objectbus.ServerBusStationDriver;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.property.client.PropertyClient;
import de.hardcode.hq.property.server.PropertyServer;
import de.hardcode.hq.property.server.PropertyService;
import de.hardcode.hq.registry.Registry;
import de.hardcode.hq.registry.client.RegistryClient;
import de.hardcode.hq.registry.server.RegistryServer;
import de.hardcode.hq.registry.server.RegistryService;
import de.hardcode.hq.time.server.TimeService;
import de.hardcode.time.SystemClock;

public class TestServer {
    static final int SERVER_DEFAULT_PORT = 13664;
    public static final Identity CHAT_ID = new NamedIdentity("CHAT");
    NetStation mStation;
    Registry mRegistry;
    Locations mLocations;
    Properties mProperties;

    public TestServer() {
        this.createServer();
    }

    void createServer() {
        this.mStation = new NetStation(13664);
        this.mStation.startReceive();
        new ChatServer(this.mStation, TestIDs.CHAT_ID);
        this.setupRegistry();
        this.setupLocations();
        this.setupProperties();
        TimeService time = new TimeService(this.mStation, TestIDs.TIME_ID, new SystemClock());
        new ServerBusStationDriver(this.mStation);
    }

    private final void setupRegistry() {
        this.mRegistry = new Registry();
        RegistryServer server = new RegistryServer(this.mStation, TestIDs.REGISTRY_ID);
        RegistryService service = new RegistryService(this.mStation, TestIDs.REGISTRY_ID, TestIDs.REGISTRY_SERVICE_ID, this.mRegistry);
        RegistryClient clt = new RegistryClient(this.mStation, TestIDs.REGISTRY_ID, TestIDs.REGISTRY_SERVICE_ID, this.mRegistry);
    }

    private final void setupLocations() {
        this.mLocations = new Locations();
        LocationsServer server = new LocationsServer(this.mStation, TestIDs.LOCATION_ID);
        LocationsClient clt = new LocationsClient(this.mStation, TestIDs.LOCATION_ID, TestIDs.LOCATION_SERVICE_ID, this.mLocations);
    }

    private final void setupProperties() {
        this.mProperties = new Properties();
        PropertyServer server = new PropertyServer(this.mStation, TestIDs.PROPERTY_ID);
        PropertyService service = new PropertyService(this.mStation, TestIDs.PROPERTY_ID, TestIDs.PROPERTY_SERVICE_ID, this.mProperties);
        PropertyClient clt = new PropertyClient(this.mStation, TestIDs.PROPERTY_ID, TestIDs.PROPERTY_SERVICE_ID, this.mProperties);
    }

    public static void main(String[] args) {
        new TestServer();
    }
}

