/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.hq.app;

import de.hardcode.hq.app.TestServer;
import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.chat.client.ChatListener;
import de.hardcode.hq.chat.client.ChatMessage;
import de.hardcode.hq.identity.ByteIdentity;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.LongIdentity;
import de.hardcode.hq.identity.NamedIdentity;
import de.hardcode.hq.objectbus.BusLine;
import de.hardcode.hq.objectbus.NetStation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;

public class TestClient {
    static final int SERVER_DEFAULT_PORT = 13664;
    NetStation mStation;
    BusLine mLine;
    ChatClient mChat;
    public static final Identity MSG_ID = new ByteIdentity(-45);
    public static final Identity MSG_ID1 = new NamedIdentity("Hello World!");
    public static final Identity MSG_ID2 = new LongIdentity(123456789L);

    public TestClient(InetAddress adr, int port) {
        this.setupClient(adr, port);
        if (null != this.mLine) {
            this.operateClient();
        }
    }

    void setupClient(InetAddress adr, int port) {
        this.mStation = new NetStation();
        this.mLine = this.mStation.createLine(adr, port);
        this.mStation.startReceive();
        this.mChat = new ChatClient(this.mStation, TestServer.CHAT_ID);
        this.mChat.send("Hi from another HARDCODE HeadQuarter chatclient!");
        this.mChat.addListener(new ChatListener(){

            public void newMessage(ChatMessage msg) {
                System.out.println(msg.getMessage());
                TestClient.this.mChat.clear();
            }
        });
        this.mLine.sendBus();
    }

    void operateClient() {
        try {
            while (true) {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String s = br.readLine();
                if ((s = s.trim()).length() <= 0) continue;
                if (s.equals("q")) {
                    System.out.println("Shutting down...");
                    this.mChat.close();
                    this.mLine.close();
                    this.mStation.close();
                    return;
                }
                if (s.equals("f")) {
                    this.flood();
                    continue;
                }
                this.mChat.send(s);
                this.mStation.flush();
            }
        }
        catch (IOException iOException) {
            this.mLine.close();
            return;
        }
    }

    private final void flood() {
        System.out.println("Starting to flood....");
        for (int i = 0; i < 10000; ++i) {
            this.mChat.send("Herkules", "************************************** This is message no. " + i + " **************************************************");
            this.mLine.sendBus();
        }
        System.out.println("....done!");
    }

    public static void main(String[] args) {
        int port = 13664;
        try {
            InetAddress adr = args.length == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(args[0]);
            System.out.println("Trying to connect to " + adr.getHostName());
            new TestClient(adr, port);
        }
        catch (Exception e) {
            System.out.println("Failed to find host!");
        }
    }
}

